<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 *  View all other existing AltumCode projects via https://altumcode.com/
 *  Get in touch for support or general queries via https://altumcode.com/contact
 *  Download the latest version via https://altumcode.com/downloads
 *
 *  X/Twitter: https://x.com/AltumCode
 *  Facebook: https://facebook.com/altumcode
 *  Instagram: https://instagram.com/altumcode
 */

defined('ALTUMCODE') || die();

return [
    'light' => [
        'slate' => [
            'name' => 'Slate',
            'color' => '#64748b',
            'colors' => [
                '50'  => '#f8fafc',
                '100' => '#f1f5f9',
                '200' => '#e2e8f0',
                '300' => '#cbd5e1',
                '400' => '#94a3b8',
                '500' => '#64748b',
                '600' => '#475569',
                '700' => '#334155',
                '800' => '#1e293b',
                '900' => '#0f172a',
            ]
        ],
        'gray' => [
            'name' => 'Gray',
            'color' => '#6b7280',
            'colors' => [
                '50'  => '#f9fafb',
                '100' => '#f3f4f6',
                '200' => '#e5e7eb',
                '300' => '#d1d5db',
                '400' => '#9ca3af',
                '500' => '#6b7280',
                '600' => '#4b5563',
                '700' => '#374151',
                '800' => '#1f2937',
                '900' => '#111827',
            ]
        ],
        'zinc' => [
            'name' => 'Zinc',
            'color' => '#71717a',
            'colors' => [
                '50'  => '#fafafa',
                '100' => '#f4f4f5',
                '200' => '#e4e4e7',
                '300' => '#d4d4d8',
                '400' => '#a1a1aa',
                '500' => '#71717a',
                '600' => '#52525b',
                '700' => '#3f3f46',
                '800' => '#27272a',
                '900' => '#18181b',
            ]
        ],
        'neutral' => [
            'name' => 'Neutral',
            'color' => '#737373',
            'colors' => [
                '50'  => '#fafafa',
                '100' => '#f5f5f5',
                '200' => '#e5e5e5',
                '300' => '#d4d4d4',
                '400' => '#a3a3a3',
                '500' => '#737373',
                '600' => '#525252',
                '700' => '#404040',
                '800' => '#262626',
                '900' => '#171717',
            ]
        ],
        'stone' => [
            'name' => 'Stone',
            'color' => '#78716c',
            'colors' => [
                '50'  => '#fafaf9',
                '100' => '#f5f5f4',
                '200' => '#e7e5e4',
                '300' => '#d6d3d1',
                '400' => '#a8a29e',
                '500' => '#78716c',
                '600' => '#57534e',
                '700' => '#44403c',
                '800' => '#292524',
                '900' => '#1c1917',
            ]
        ],
    ],

    'dark' => [
        'slate' => [
            'name' => 'Slate',
            'color' => '#64748b',
            'colors' => [
                '900' => '#f0f2f4',
                '800' => '#d6dbe1',
                '700' => '#b2bbc7',
                '600' => '#9da8b8',
                '500' => '#6b7c94',
                '400' => '#5c6b7f',
                '300' => '#3a434f',
                '200' => '#2d343e',
                '100' => '#181b21',
                '50'  => '#0d0f12',
            ],
        ],
        'gray' => [
            'name' => 'Gray',
            'color' => '#6b7280',
            'colors' => [
                '900' => '#f1f2f3',
                '800' => '#d8dadb',
                '700' => '#b7bbc3',
                '600' => '#a3a8b3',
                '500' => '#747c8b',
                '400' => '#646a77',
                '300' => '#3f434b',
                '200' => '#31343a',
                '100' => '#1a1b1f',
                '50'  => '#0e0f11',
            ],
        ],
        'zinc' => [
            'name' => 'Zinc',
            'color' => '#71717a',
            'colors' => [
                '900' => '#f2f2f3',
                '800' => '#dadadd',
                '700' => '#bababf',
                '600' => '#a7a7ae',
                '500' => '#7a7a84',
                '400' => '#696971',
                '300' => '#424747',
                '200' => '#323238',
                '100' => '#181820',
                '50'  => '#0a0a14',
            ],
        ],
        'neutral' => [
            'name' => 'Neutral',
            'color' => '#737373',
            'colors' => [
                '900' => '#f2f2f2',
                '800' => '#dbdbdb',
                '700' => '#bdbdbd',
                '600' => '#ababab',
                '500' => '#808080',
                '400' => '#6e6e6e',
                '300' => '#454545',
                '200' => '#363636',
                '100' => '#1c1c1c',
                '50'  => '#0f0f0f',
            ],
        ],
        'stone' => [
            'name' => 'Stone',
            'color' => '#78716c',
            'colors' => [
                '900' => '#f3f2f1',
                '800' => '#dddbda',
                '700' => '#c0bcb9',
                '600' => '#afaaa7',
                '500' => '#857e79',
                '400' => '#6e6d6c',
                '300' => '#474442',
                '200' => '#393431',
                '100' => '#211b17',
                '50'  => '#140e09',
            ],
        ],
    ]
];
